	function  N = L_PHASE_LP_HB_FIR_ORDER(wsT, ds)
 
	%	Computes the order of an even-order, half-band, equiripple,  
	%	linear-phase lowpass FIR filter.
 	 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2011-02-11
	% 	Modified by: 	LW 2017-02-06
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	[N, Be, D, W] = HERRMANN_LP_FIR_ORDER([pi-wsT, wsT], [ds ds]);
	N = 4*round((N-1)/4)+2; % Make sure that it is a half-band filter
